//	GeometryGamesUtilities.swift
//
//	© 2020 by Jeff Weeks
//	See TermsOfUse.txt

import UIKit


func MainScreenSupportsP3() -> Bool {

#if targetEnvironment(simulator)
#warning("Re-evaluate this code (and comment) once the simulator is running on an Apple Silicon Mac.")
	//	The iOS simulator will claim to support Display P3
	//	whenever the simulated device does, but in reality
	//	it renders only in non-extended sRGB.
	return false
#else
	return UIScreen.main.traitCollection.displayGamut == UIDisplayGamut.P3
#endif
}


func MakeSwiftString(zeroTerminatedString: UnsafeMutablePointer<Char16>) -> String {

	let theSwiftString = String(
							utf16CodeUnits: zeroTerminatedString,
							count: Strlen16(zeroTerminatedString))

	return theSwiftString
}
